const toasts = [
  {
    name: "Dewi Clarissa",
    city: "Jakarta",
    message: "Telah membeli",
    product: "Etawalin Paket 3 Box + Gratis Ongkir",
    time: "2 menit yang lalu",
  },
  {
    name: "Ahmad Janoko",
    city: "Surabaya",
    message: "Telah membeli",
    product: "Etawalin Paket 2 Box + Gratis Ongkir",
    time: "11 menit yang lalu",
  },
  {
    name: "Ananda Darmawansyah",
    city: "Bandung",
    message: "Telah membeli",
    product: "Etawalin Paket 2 Box",
    time: "2 jam yang lalu",
  },
  {
    name: "Bimo Hadi",
    city: "Bandung",
    message: "Telah membeli",
    product: "Etawalin Paket 2 Box",
    time: "2 jam yang lalu",
  },
  {
    name: "Edi Saputra",
    city: "Medan",
    message: "Telah membeli",
    product: "Etawalin Paket 3 Box + Gratis Ongkir",
    time: "1 menit yang lalu",
  },
];

function showToast() {
  const toastContainer = document.getElementById("toast-container");

  const randomToast = toasts[Math.floor(Math.random() * toasts.length)];

  const toastElement = document.createElement("div");
  toastElement.className = "toast";
  toastElement.setAttribute("role", "alert");
  toastElement.setAttribute("aria-live", "assertive");
  toastElement.setAttribute("aria-atomic", "true");

  toastElement.innerHTML = `
            <div class="toast-body">
            <div class="row">
                <div class="col-4">
                    <img src="src/assets/toast.webp"> 
                </div>
                <div class="col">
                    <button type="button" class="btn-close position-absolute top-0 end-0 p-2" data-bs-dismiss="toast" aria-label="Close"></button>
                    <p class="m-0 fw-medium">${randomToast.name}</p>
                    <p class="m-0 fw-medium">${randomToast.city}</p>
                    <p class="m-0 fw-medium">${randomToast.message} <span class="text-danger fw-bold">${randomToast.product}</span></p>
                    <p class="m-0 fw-medium">${randomToast.time}</p>
                </div>
            </div>
            </div>`;

  toastContainer.appendChild(toastElement);

  const toast = new bootstrap.Toast(toastElement, {
    delay: 5000,
  });

  toast.show();

  toastElement.addEventListener("hidden.bs.toast", () => {
    toastElement.remove();
  });
}

setInterval(showToast, 15000);
